// *********************************************************
// CLOCK MODIFIER INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
// *********************************************************
//
// Created by Chris Colefax, 24 June 1997
//
// See "ClockMod.txt" for more information.
//
// *********************************************************

// CHECK CLOCK PARAMETERS
// **********************
   #declare _CM_tempver = version #version 3.0
   #ifndef (clock_type)     #declare clock_type     = ""    #end
   #ifndef (clock_start)    #declare clock_start    = 0     #end
   #ifndef (clock_finish)   #declare clock_finish   = 1     #end
   #ifndef (clock_repeat)   #declare clock_repeat   = 1     #end
   #ifndef (clock_strength) #declare clock_strength = 1     #end
   #ifndef (clock_combine)  #declare clock_combine  = ""    #end
   #ifndef (clock_preview)  #declare clock_preview  = false #end
   #ifndef (_CM_combine)    #declare _CM_combine    = 0     #end

   #if (clock_start >= clock_finish)
      #warning "clock_start must be less than clock_finish!\n"
      #declare clock_start = 0 #declare clock_finish = 1
   #end

   #if (clock_repeat <= 0)
      #warning "clock_repeat must be larger than 0!\n"
      #declare clock_repeat = 1
   #end

// DETERMINE CURRENT CLOCK VALUE
// *****************************
   #if (_CM_combine = 0) #if (clock_preview = false) #declare iclock = clock #end
      #else #declare iclock = mclock #end

// DETERMINE COMBINATION CLOCK TYPE
// ********************************
   #if (strlen(clock_combine) > 0 & _CM_combine = 0)
      #declare _CM_type = asc(strupr(clock_combine))
      #declare _CM_clock = iclock
      #declare _CM_clevel = 1

// DETERMINE CLOCK TYPE
// ********************
   #else #if (strlen(clock_type) = 0) #declare _CM_type = 0
      #else #declare _CM_type = asc(strupr(clock_type)) #end
      #if (iclock < clock_start) #declare _CM_clock = 0
         #else #if (iclock > clock_finish) #declare _CM_clock = 1
         #else #declare _CM_clock = mod((iclock - clock_start) * clock_repeat / (clock_finish - clock_start), 1)
      #end #end
      #declare _CM_clevel = 0
   #end

// CALCULATE MODIFIED CLOCK VALUE
// ******************************
   #switch (_CM_type)
      #case (asc("A"))
         #declare mclock = pow(_CM_clock, 2 * clock_strength) #break
      #case (asc("D"))
         #declare mclock = pow(_CM_clock, .5 / clock_strength) #break
      #case (asc("S"))
         #declare mclock = sin((_CM_clock - .5) * pi) / 2 + .5 #break
      #case (asc("T"))
         #declare mclock = (abs(_CM_clock - .5) - .5) * -2 #break
      #case (asc("J"))
         #declare mclock = 1 - pow(abs(_CM_clock * 2 - 1), 2 * clock_strength) #break
      #case (asc("B"))
         #declare mclock = 1 - pow(1 - abs(_CM_clock * 2 - 1), 2 * clock_strength) #break
      #case (asc("O"))
         #declare mclock = sin(_CM_clock * 2 * pi) #break
      #case (asc("W"))
         #declare mclock = sin((_CM_clock -.25) * 2 * pi) * .5 + .5 #break
      #case (asc("R"))
         #declare mclock = (_CM_clock < 0.5 ?
            pow(_CM_clock * 2, .25 / clock_strength) :
            pow(1 - (_CM_clock * 2 - 1), 4 * clock_strength)) #break
      #else
         #declare mclock = _CM_clock
   #end

// CALCULATE COMBINED CLOCK
// ************************
   #declare _CM_combine = _CM_combine + 1
   #if (_CM_combine > _CM_clevel) #declare _CM_combine = 0 #end
   #if (_CM_combine > 0) #include "ClockMod.inc" #end
   #version _CM_tempver
